using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
		      double y;
		      int f, r;
            CPDF pdf = new CPDF();
            pdf.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            pdf.CreateNewPDF(null);

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.Append();
               y = 50.0;
               pdf.SetFont("Helvetica", TFStyle.fsRegular, 10.0, false, TCodepage.cp1252);
               pdf.WriteText(50.0, y, "Text fields:");

               y += 15.0;
               f = pdf.CreateTextField("Text1", -1, false, 0, 50.0, y, 200.0, 20.0);
               pdf.SetTextFieldValue(f, null, "Single line text...", TTextAlign.taLeft);

               y += 30.0;
               f = pdf.CreateTextField("Text2", -1, true, 0, 50.0, y, 200.0, 50.0);
               pdf.SetTextFieldValue(f, null, "This field accepts multi-line text. The maximum text length can be restricted if necessary.", TTextAlign.taLeft);

               y += 60.0;
               pdf.WriteText(50.0, y, "A password field:");
               y += 15.0;
               f = pdf.CreateTextField("Text3", -1, false, 0, 50.0, y, 200.0, 20.0);
               pdf.SetFieldFlags(f, TFieldFlags.ffPassword, false);
               pdf.SetTextFieldValue(f, null, "**********", TTextAlign.taLeft);

               y += 30.0;
               pdf.WriteText(50.0, y, "A fixed length field separated into combs:");
               y += 15.0;
               f = pdf.CreateTextField("Text4", -1, false, 10, 50.0, y, 200.0, 20.0);
               pdf.SetTextFieldValue(f, null, "Test value", TTextAlign.taLeft);
               pdf.SetFieldFlags(f, TFieldFlags.ffComb, false);


               y = 50.0;
               pdf.WriteText(350.0, y, "Choice fields:");
               y += 15.0;
               f = pdf.CreateComboBox("Combo1", true, -1, 350.0, y, 200.0, 20.0);
               pdf.AddValToChoiceField(f, null, " Select a value...", true);
               pdf.AddValToChoiceField(f, "Apple",  "Apple",  false);
               pdf.AddValToChoiceField(f, "Banana", "Banana", false);
               pdf.AddValToChoiceField(f, "Pear",   "Pear",   false);
               pdf.AddValToChoiceField(f, "Grape",  "Grape",  false);
               pdf.AddValToChoiceField(f, "Orange", "Orange", false);

               y += 30.0;
               f = pdf.CreateListBox("List", true, -1, 350.0, y, 200.0, 50.0);
               pdf.AddValToChoiceField(f, "Apple",  "Apple",  false);
               pdf.AddValToChoiceField(f, "Banana", "Banana", true);
               pdf.AddValToChoiceField(f, "Pear",   "Pear",   false);
               pdf.AddValToChoiceField(f, "Grape",  "Grape",  false);
               pdf.AddValToChoiceField(f, "Orange", "Orange", false);

               y += 60.0;
               pdf.WriteText(350.0, y, "Editable combo box:");
               y += 15.0;
               f = pdf.CreateComboBox("Combo2", true, -1, 350.0, y, 200.0, 20.0);
               pdf.AddValToChoiceField(f, "Apple",  "Apple",  false);
               pdf.AddValToChoiceField(f, "Banana", "Banana", false);
               pdf.AddValToChoiceField(f, "Pear",   "Pear",   false);
               pdf.AddValToChoiceField(f, "Grape",  "Grape",  false);
               pdf.AddValToChoiceField(f, "Orange", "Orange", false);
               pdf.SetFieldFlags(f, TFieldFlags.ffEdit, false);
               pdf.SetFieldExpValue(f, 1000, "Select or enter a value...", null, true);

               y += 30.0;
               pdf.WriteText(350.0, y, "Check boxes / Radio buttons:");

               y += 15.0;
               pdf.ChangeFontSize(1.0);
               f = pdf.CreateCheckBox("N1", "C1", true, -1, 350.0, y, 20.0, 20.0);
               f = pdf.CreateCheckBox("N2", "C2", true, -1, 380.0, y, 20.0, 20.0);
               f = pdf.CreateCheckBox("N3", "C1", true, -1, 410.0, y, 20.0, 20.0);

               pdf.CreateCheckBox("G1", "C1", false, -1, 450.0, y, 20.0, 20.0);
               pdf.CreateCheckBox("G1", "C2", false, -1, 480.0, y, 20.0, 20.0);
               pdf.CreateCheckBox("G1", "C1", true,  -1, 510.0, y, 20.0, 20.0);
               pdf.CreateCheckBox("G1", "C2", false, -1, 540.0, y, 20.0, 20.0);

               y += 30.0;
               pdf.ChangeFontSize(15.0);
               pdf.SetCheckBoxChar(TCheckBoxChar.ccCircle);
               r = pdf.CreateRadioButton("Radio1", "R1", true, -1, 350.0, y, 20.0, 20.0);
               pdf.SetCheckBoxDefState(r, false);
               pdf.CreateCheckBox(null, "R2", false, r, 380.0, y, 20.0, 20.0);
               pdf.CreateCheckBox(null, "R3", false, r, 410.0, y, 20.0, 20.0);

               r = pdf.CreateRadioButton("Radio2", "R1", true, -1, 450.0, y, 20.0, 20.0);
               pdf.SetFieldFlags(r, TFieldFlags.ffRadioIsUnion, false);
               pdf.CreateCheckBox(null, "R2", false, r, 480.0, y, 20.0, 20.0);
               pdf.CreateCheckBox(null, "R1", true,  r, 510.0, y, 20.0, 20.0);
               pdf.CreateCheckBox(null, "R2", false, r, 540.0, y, 20.0, 20.0);
            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
